﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.SessionState;
using System.Data;
using System.Data.SqlClient;
using DotNet.FrameWork.Data;

namespace HteamDd.Web.ashx
{
    /// <summary>
    /// Dd_text 的摘要说明
    /// </summary>
    public class Dd_text : IHttpHandler,IRequiresSessionState
    {
        HaTeam.Dd.Model.Dd_Text model = new HaTeam.Dd.Model.Dd_Text();
        HaTeam.Dd.BLL.Dd_Text bll = new HaTeam.Dd.BLL.Dd_Text();
        HaTeam.Dd.Model.Dd_Reprint reprint_model = new HaTeam.Dd.Model.Dd_Reprint();
        HaTeam.Dd.BLL.Dd_Reprint reprint_bll = new HaTeam.Dd.BLL.Dd_Reprint();
        public void ProcessRequest(HttpContext context)
        {
            if(context.Session["text_mark_ID"] == null && context.Request["state"] != "reship_text")//进行判断，如果没有进行编辑的操作，进行添加操作
            {
                int _num = Dd_textInsert(context);
                context.Response.Write(_num);
            }
            else if (context.Request["state"] == "text")//如果进行编辑的操作，对应的要进行update更新操作
            {
                string updata = "update Dd_Text set Text_Title=@title,Text_Content=@content,Text_Tag=@tag where Text_ID=@ID";
                SqlParameter[] texts = { 
                                       new SqlParameter("@ID",SqlDbType.Int),
                                       new SqlParameter("@title",SqlDbType.NVarChar,50),
                                       new SqlParameter("@content",SqlDbType.NVarChar,4000),
                                       new SqlParameter("@tag",SqlDbType.NVarChar,100)
                                       };
                texts[0].Value = context.Session["text_mark_ID"].ToString();
                texts[1].Value = context.Request.Params["title"].ToString();
                texts[2].Value = context.Request.Params["content"].ToString();
                texts[3].Value =Lable_Prc(context);
                if (DbHelperSQL.ExecuteSql(updata, texts) != 0)
                {
                    context.Response.Write("1");
                    context.Session.Remove("text_mark_ID");
                }
                else
                {
                    context.Response.Write("-1");
                }
            }
            else if (context.Request["state"] == "reship_text")//转载
            {
                reprint_model.Reprint_UserID = Convert.ToInt32(context.Request.Params["userID"].ToString());//本地用户
                reprint_model.Reprint_CopyFrom = Convert.ToInt32(context.Request.Params["CopyFrom"]);//转载自哪个用户
                reprint_model.Reprint_type = Convert.ToInt32(context.Request.Params["Order"]);//转载的类型
                reprint_model.Reprint_ArticleID = Convert.ToInt32(context.Request.Params["ArticleID"]);//转载的（文章，图片，链接……）ID
                reprint_model.Reprint_OriginID = Convert.ToInt32(context.Request["originID"]);
                reprint_model.Reprint_Guid = Convert.ToString(Guid.NewGuid());
                reprint_model.Reprint_Datetime = DateTime.Now;
                reprint_model.Reprint_UpDatetime = DateTime.Now;
                reprint_model.Reprint_Verify = 0;
                reprint_model.Reprint_Lock = 0;
                reprint_model.Reprint_State = 0;
                reprint_model.Reprint_Delete = 0;
                reprint_model.Reprint_Count = 0;
                reprint_model.Reprint_Order = 0;
                reprint_model.Reprint_Remark = null;
                int _num = 0;
                try
                {
                    _num = reprint_bll.Add(reprint_model);
                    if (_num != 0)
                    {
                        _num = 1;
                    }
                }
                catch
                {
                    _num = -1;
                }
                context.Response.Write(_num);
                Dd_textInsert(context);
            }
        }

        private int Dd_textInsert(HttpContext context)
        {
            string lable = Lable_Prc(context);
            string title = context.Request.Params["title"].ToString();
            string content = context.Request.Params["content"].ToString();
            string check = context.Request.Params["check"].ToString();
            model.User_ID = Convert.ToInt32(context.Request.Params["userID"].ToString());
            model.Text_Title = title;
            model.Text_Content = content;
            model.Text_Tag = lable;
            model.Text_OriginId = model.User_ID;
            model.Text_PublishMode = 1;
            model.Text_PutTop = Convert.ToBoolean(check);
            model.Text_Fever = 0;
            model.Text_Guid = Convert.ToString(Guid.NewGuid());
            model.Text_Datetime = DateTime.Now;
            model.Text_UpDatetime = DateTime.Now;
            model.Text_Verify = 0;
            model.Text_Lock = 0;
            model.Text_State = 0;
            model.Text_Delete = 0;
            model.Text_Count = 0;
            model.Text_Order = 0;
            int _num = 0;
            try
            {
                _num = bll.Add(model);
                if (_num != 0)
                {
                    _num = 1;
                }
            }
            catch
            {
                _num = -1;
            }
            return _num;
        }

        /// <summary>
        /// 对标签的处理
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        private static string Lable_Prc(HttpContext context)
        {
            string lable = "";
            if (context.Request.Params["lable"] == "")
            {
                if (context.Request.Params["title"] != "" & context.Request.Params["content"] == "")
                {
                    lable = context.Request.Params["title"].ToString().Substring(0, 2);
                }
                else if (context.Request.Params["content"] != "" & context.Request.Params["title"] == "")
                {
                    lable = context.Request.Params["content"].ToString().Substring(0, 2);
                }
                else
                {
                    lable = context.Request.Params["title"].ToString().Substring(0, 2);
                }
            }
            else
            {
                lable = context.Request.Params["lable"].ToString();
            }
            return lable;
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}